/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230510
* Description : 通过PB4和PA1输出系统时钟
* Note        : None
********************************************************************************/
#include "AD18F08.h"
#include <stdio.h>


/*********************************************************************************************
*
* _FINTOSC_DIV1   :  内部RC振荡器频率选择
* _DBG_OFF        :  DEBUG模式使能位
* _LVREN_ON       :  LVR使能
* _LVR24V         :  LVR的电压选择为2.4V
* _FLASH_CP1_OFF  :  1K~2K*16 FLASH CP保护
* _FLASH_CP0_OFF  :  0~1K*16 FLASH CP保护
* _IDIS_OFF	      :  模拟IO打开，数据读取控制位
* _CKSUM_OFF      :  校验使能位
* _CBP_OFF	      :  代码保护选择位
* _RESETE_OFF     :  外部复位使能
* _RSEL		      :  端口上下拉电阻选择
* _STV_ON		  :  堆栈溢出复位
* _PSUT_2		  :  上电复位时间选择
* _FCPU_4T        :  指令周期选择4T
* _WDTE_OFF       :  看门狗使能
* _TWDT_000       :  看门狗溢出时间选择
* _OSCM_HIRC_16M  :  系统时钟选择高速时钟
* _MTPDIS_OFF     :  SWD模式下读FALSH控制
* _ADCSP_ON	      :	 ADC采集速度选择
*

************************************************************************************************/


__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_ON_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_LOW_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                     );

//

void main(void)
{

	TRISA1 = 0; //PA1设置为输出
	TRISB4 = 0; //PB4设置为输出
//-----------------输出高速时钟-------------------
	// OSCCON =0X6F;	//16MHz 2分频输出8MHz
	 OSCCON =0X7F;		//16MHz 1分频输出16Mhz
	//OSCCON =0X5F;		//16MHz 4分频输出4MHz
	//OSCCON =0X4F;		//16MHz 8分频输出2MHz
	//OSCCON =0X3F;		//16MHz 16分频输出1MHz

//-----------------输出低速时钟-------------------
	//OSCCON =0X6c;		//2KHz 2分频输出1KHz
	// OSCCON =0X7c;	//2KHz 1分频输出2KHz
	//OSCCON =0X5c;		//2kHz 4分频输出500Hz
	//OSCCON =0X4c;		//2kHz 8分频输出250Hz
	//OSCCON =0X3c;		//2kHz 16分频输出125Hz

//--------------输出32M 的时钟---------------------
	//PLL = 1;			//系统时钟倍频到32MHz

	while(1);
}
//高优先级中断服务函数

void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断



}

//低优先级中断服务函数

void interrupt low_priority ISR_l (void)
{


}

